/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    aic3106_test.c
 *
 * \brief   Routines to test the Audio Codec on Base EVM
 *
 * This file contains the routines for configuring and testing the AIC3106 Audio
 * codec on the Base Board.
 *
 * \author  0043
 *
 * \version 01a,19aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_i2c.h"
#include "aic3106.h"
#include "stdio.h"
 
/*
 *====================
 * Extern declarations
 *====================
 */
extern STATUS aic3106_headphone_out (UINT8    u8McaspNum);
extern STATUS aic3106_lineout_out (UINT8    u8McaspNum);
extern STATUS aic3106_MicHeadphone_Loop(UINT8    u8McaspNum);
extern STATUS aic3106_LineInLineOut_Loop (UINT8    u8McaspNum);


/*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to test the AIC3106 Audio codec on Base board
 *
 * This routine initializes the AIC3106 Audio Codec on the base board to test
 * various interfaces including the following
 *	(a) Playback on Head-phohne
 *  (b) Playback on Line-Out
 *  (c) Loopback the input on Microphone to head-set.
 *  (d) Loopback the input on Line-In to Line-Out
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106_tests
(
	UINT8    u8McaspNum
)
{	/* begin aic3106_tests */
	STATUS u32RetVal = SUCCESS;
	
	/* Initialize the I2C bus */
	u32RetVal = DM814xI2cInit(AIC3106_I2C_BUS_NUM);
	
	if (SUCCESS != u32RetVal)
	{
		printf ("I2C initialization failed for buss number %d.\r\n", AIC3106_I2C_BUS_NUM);
		return FAILED;
	}
	
	printf (" ===========================================================\r\n");
	printf (" *******  AUDIO CODEC AIC3106 TEST ON BASE BOARD  **********\r\n");
	printf (" This test covers connectivity tests to AIC3106 on the base \r\n");
	printf (" for head-phone, Line-out, microphone & Line-in. For this   \r\n");
	printf (" ensure the following :- \r\n");
	printf ("     (a) Head phone connected to the Head-phone jack. \r\n");
	printf ("     (b) Speakers connected to the Line-Out jack. \r\n");
	printf ("     (c) Stereo Audio cable feeding into the Line-In jack. \r\n");
	printf ("     (d) Microphone connected to the microphone jack. \r\n");
	
	printf (" Playing the sine tone on the Head phone \r\n");
	printf (" Look for the tone on the Head phone for the next 5 seconds.\r\n");
	u32RetVal = aic3106_headphone_out (u8McaspNum);
	if (FAILED == u32RetVal)
	{
		printf (" Error occured during the configuraiton of AIC3106.\r\n");
		return (u32RetVal);
	}
	
	printf (" Playing the sine tone the Line-out. \r\n");
	printf (" Look for tone being played back on Speakers for next 5 seconds \r\n");
	u32RetVal = aic3106_lineout_out (u8McaspNum);
	if (FAILED == u32RetVal)
	{
		printf (" Error occured during the configuraiton of AIC3106.\r\n");
		return (u32RetVal) ;
	}

	printf (" Loopback of Microphone to the headphone. \r\n");
	printf (" Speak on the microphone and hear back on the head phone. \r\n");
	u32RetVal = aic3106_MicHeadphone_Loop (u8McaspNum);
	if (FAILED == u32RetVal)
	{
		printf (" Error occured during the configuraiton of AIC3106.\r\n");
		return (u32RetVal);
	}

	printf (" Loopback of Line-In to the Line-Out. \r\n");
	printf (" Feed the stereo audio into the Line in and hear back on speaker. \r\n");
	u32RetVal = aic3106_LineInLineOut_Loop (u8McaspNum);
	if (FAILED == u32RetVal)
	{
		printf (" Error occured during the configuraiton of AIC3106.\r\n");
		return (u32RetVal);
	}
	
	return (u32RetVal);
}	/* end aic3106_tests */
